/** GUI biuro **/

function activateBankrut(force) {
	/**
	 * Dialog definitions
	 **/
	function showDlg() {
		if (window.BankrutDlgOpened) return;
		window.BankrutDlgLastFired = new Date();

		var template = '<div id="dialog-bankrut" title="Informacja">' +
			'	<div id="mainblock" style="width: 100%; clear: both; overflow: hidden;">' +
			'		<div class="barbutton2 hover2" style="cursor: default; background: url(\'images/gui/info-icon-sm.png\') no-repeat; width:35px; height: 35px; float: left; border:0; padding:0; position: absolute; top:7px; left:2px; z-index: 999;"></div>' +
			'		<div class="row" style="text-align:center" id="info-naglowek">Bankructwo!</div>' +
			'		<div class="register-form-left" style="float: right;">' +
			'			<div class="row infodiv" id="info-tresc">Środki na twoim koncie uległy wyczerpaniu. Firma zbankrutowała!</div>' +
			'		</div>' +
			'	</div>' +
			'	<div class="row buttons" style="width: 100%; text-align: center;">' +
			'		<input type="button" id="bankructwo-ok" name="submit" value="OK" class="infodialog-button-ok ui-button ui-widget ui-state-default ui-corner-all" role="button" aria-disabled="false" />' +
			'	</div>' +
			'</div>';

		$(template).dialog({
			autoOpen: true,
			hide: {
				effect: 'clip',
				duration: 500
			},
			show: {
				effect: 'scale',
				duration: 600
			},
			position: {
				my: "center",
				at: "center",
				of: window
			},
			close: function() {
				window.BankrutDlgOpened = false;
				$(this).parent().remove();
				var back = $('#button-back');
				if (back.is(':visible') && force)
					back.click();
			},
			open: function() {
				window.BankrutDlgOpened = true;
				var _dlg = $(this);
				_dlg.find('#bankructwo-ok').click(function() {
					_dlg.dialog('close');
				});
			},
			closeOnEscape: false,
			draggable: true,
			resizable: false,
			width: 500,
			modal: true
		});
	}

	if (window.BankrutDlgLastFired) {
		var startTime = window.BankrutDlgLastFired;
		var startMsec = startTime.getTime();
		var now = new Date();
		var elapsed = (now.getTime() - startMsec) / 1000;
		if (elapsed > 5 * 60)
			showDlg();
	} else showDlg();
}
